package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableAddOnRequest(
    addOnType: zio.aws.lightsail.model.AddOnType,
    resourceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest = {
    import DisableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
      .builder()
      .addOnType(addOnType.unwrap)
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DisableAddOnRequest.ReadOnly =
    zio.aws.lightsail.model.DisableAddOnRequest.wrap(buildAwsValue())
}
object DisableAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DisableAddOnRequest =
      zio.aws.lightsail.model.DisableAddOnRequest(addOnType, resourceName)
    def addOnType: zio.aws.lightsail.model.AddOnType
    def resourceName: ResourceName
    def getAddOnType: ZIO[Any, Nothing, zio.aws.lightsail.model.AddOnType] =
      ZIO.succeed(addOnType)
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ) extends zio.aws.lightsail.model.DisableAddOnRequest.ReadOnly {
    override val addOnType: zio.aws.lightsail.model.AddOnType =
      zio.aws.lightsail.model.AddOnType.wrap(impl.addOnType())
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ): zio.aws.lightsail.model.DisableAddOnRequest.ReadOnly = new Wrapper(impl)
}
