package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Disk(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    addOns: Option[Iterable[zio.aws.lightsail.model.AddOn]] = None,
    sizeInGb: Option[Integer] = None,
    isSystemDisk: Option[Boolean] = None,
    iops: Option[Integer] = None,
    path: Option[String] = None,
    state: Option[zio.aws.lightsail.model.DiskState] = None,
    attachedTo: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None,
    attachmentState: Option[String] = None,
    gbInUse: Option[Integer] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Disk
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        attachedTo.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.attachedTo)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(attachmentState.map(value => value: java.lang.String))(
        _.attachmentState
      )
      .optionallyWith(gbInUse.map(value => value: java.lang.Integer))(_.gbInUse)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Disk.ReadOnly =
    zio.aws.lightsail.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Disk] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Disk = zio.aws.lightsail.model.Disk(
      name.map(value => value),
      arn.map(value => value),
      supportCode.map(value => value),
      createdAt.map(value => value),
      location.map(value => value.asEditable),
      resourceType.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      addOns.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      sizeInGb.map(value => value),
      isSystemDisk.map(value => value),
      iops.map(value => value),
      path.map(value => value),
      state.map(value => value),
      attachedTo.map(value => value),
      isAttached.map(value => value),
      attachmentState.map(value => value),
      gbInUse.map(value => value)
    )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Option[List[zio.aws.lightsail.model.AddOn.ReadOnly]]
    def sizeInGb: Option[Integer]
    def isSystemDisk: Option[Boolean]
    def iops: Option[Integer]
    def path: Option[String]
    def state: Option[zio.aws.lightsail.model.DiskState]
    def attachedTo: Option[ResourceName]
    def isAttached: Option[Boolean]
    def attachmentState: Option[String]
    def gbInUse: Option[Integer]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      AwsError.unwrapOptionField("addOns", addOns)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
    def getIsSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDisk)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.DiskState] =
      AwsError.unwrapOptionField("state", state)
    def getAttachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
    def getAttachmentState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentState", attachmentState)
    def getGbInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gbInUse", gbInUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ) extends zio.aws.lightsail.model.Disk.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns: Option[List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      scala
        .Option(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override val sizeInGb: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override val isSystemDisk: Option[Boolean] =
      scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val state: Option[zio.aws.lightsail.model.DiskState] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.DiskState.wrap(value))
    override val attachedTo: Option[ResourceName] = scala
      .Option(impl.attachedTo())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
    override val attachmentState: Option[String] =
      scala.Option(impl.attachmentState()).map(value => value: String)
    override val gbInUse: Option[Integer] =
      scala.Option(impl.gbInUse()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ): zio.aws.lightsail.model.Disk.ReadOnly = new Wrapper(impl)
}
