package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ResourceName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskMap(
    originalDiskPath: Option[NonEmptyString] = None,
    newDiskName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskMap = {
    import DiskMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskMap
      .builder()
      .optionallyWith(
        originalDiskPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originalDiskPath)
      .optionallyWith(
        newDiskName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.newDiskName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskMap.ReadOnly =
    zio.aws.lightsail.model.DiskMap.wrap(buildAwsValue())
}
object DiskMap {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskMap] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskMap =
      zio.aws.lightsail.model.DiskMap(
        originalDiskPath.map(value => value),
        newDiskName.map(value => value)
      )
    def originalDiskPath: Option[NonEmptyString]
    def newDiskName: Option[ResourceName]
    def getOriginalDiskPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originalDiskPath", originalDiskPath)
    def getNewDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("newDiskName", newDiskName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ) extends zio.aws.lightsail.model.DiskMap.ReadOnly {
    override val originalDiskPath: Option[NonEmptyString] = scala
      .Option(impl.originalDiskPath())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val newDiskName: Option[ResourceName] = scala
      .Option(impl.newDiskName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ): zio.aws.lightsail.model.DiskMap.ReadOnly = new Wrapper(impl)
}
