package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DiskSnapshot(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    sizeInGb: Option[Integer] = None,
    state: Option[zio.aws.lightsail.model.DiskSnapshotState] = None,
    progress: Option[String] = None,
    fromDiskName: Option[ResourceName] = None,
    fromDiskArn: Option[NonEmptyString] = None,
    fromInstanceName: Option[ResourceName] = None,
    fromInstanceArn: Option[NonEmptyString] = None,
    isFromAutoSnapshot: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskSnapshot = {
    import DiskSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshot
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        fromDiskName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.fromDiskName)
      .optionallyWith(
        fromDiskArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.fromDiskArn)
      .optionallyWith(
        fromInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.fromInstanceName)
      .optionallyWith(
        fromInstanceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromInstanceArn)
      .optionallyWith(
        isFromAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.isFromAutoSnapshot)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskSnapshot.ReadOnly =
    zio.aws.lightsail.model.DiskSnapshot.wrap(buildAwsValue())
}
object DiskSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskSnapshot =
      zio.aws.lightsail.model.DiskSnapshot(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sizeInGb.map(value => value),
        state.map(value => value),
        progress.map(value => value),
        fromDiskName.map(value => value),
        fromDiskArn.map(value => value),
        fromInstanceName.map(value => value),
        fromInstanceArn.map(value => value),
        isFromAutoSnapshot.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def sizeInGb: Option[Integer]
    def state: Option[zio.aws.lightsail.model.DiskSnapshotState]
    def progress: Option[String]
    def fromDiskName: Option[ResourceName]
    def fromDiskArn: Option[NonEmptyString]
    def fromInstanceName: Option[ResourceName]
    def fromInstanceArn: Option[NonEmptyString]
    def isFromAutoSnapshot: Option[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.DiskSnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getFromDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromDiskName", fromDiskName)
    def getFromDiskArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromDiskArn", fromDiskArn)
    def getFromInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromInstanceName", fromInstanceName)
    def getFromInstanceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArn)
    def getIsFromAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ) extends zio.aws.lightsail.model.DiskSnapshot.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val sizeInGb: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override val state: Option[zio.aws.lightsail.model.DiskSnapshotState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.lightsail.model.DiskSnapshotState.wrap(value))
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val fromDiskName: Option[ResourceName] = scala
      .Option(impl.fromDiskName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val fromDiskArn: Option[NonEmptyString] = scala
      .Option(impl.fromDiskArn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromInstanceName: Option[ResourceName] = scala
      .Option(impl.fromInstanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val fromInstanceArn: Option[NonEmptyString] = scala
      .Option(impl.fromInstanceArn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val isFromAutoSnapshot: Option[Boolean] =
      scala.Option(impl.isFromAutoSnapshot()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ): zio.aws.lightsail.model.DiskSnapshot.ReadOnly = new Wrapper(impl)
}
