package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait DiskState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.DiskState
}
object DiskState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.DiskState
  ): zio.aws.lightsail.model.DiskState = value match {
    case software.amazon.awssdk.services.lightsail.model.DiskState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.DiskState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.lightsail.model.DiskState.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.lightsail.model.DiskState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.lightsail.model.DiskState.IN_USE =>
      val r = `in-use`
      r
    case software.amazon.awssdk.services.lightsail.model.DiskState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.PENDING
  }
  case object error extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.ERROR
  }
  case object available extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.AVAILABLE
  }
  case object `in-use` extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.IN_USE
  }
  case object unknown extends zio.aws.lightsail.model.DiskState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskState =
      software.amazon.awssdk.services.lightsail.model.DiskState.UNKNOWN
  }
}
