package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DomainValidationRecord(
    domainName: Option[DomainName] = None,
    resourceRecord: Option[zio.aws.lightsail.model.ResourceRecord] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DomainValidationRecord = {
    import DomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DomainValidationRecord.ReadOnly =
    zio.aws.lightsail.model.DomainValidationRecord.wrap(buildAwsValue())
}
object DomainValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DomainValidationRecord =
      zio.aws.lightsail.model.DomainValidationRecord(
        domainName.map(value => value),
        resourceRecord.map(value => value.asEditable)
      )
    def domainName: Option[DomainName]
    def resourceRecord: Option[zio.aws.lightsail.model.ResourceRecord.ReadOnly]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getResourceRecord
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceRecord.ReadOnly] =
      AwsError.unwrapOptionField("resourceRecord", resourceRecord)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ) extends zio.aws.lightsail.model.DomainValidationRecord.ReadOnly {
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val resourceRecord
        : Option[zio.aws.lightsail.model.ResourceRecord.ReadOnly] = scala
      .Option(impl.resourceRecord())
      .map(value => zio.aws.lightsail.model.ResourceRecord.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ): zio.aws.lightsail.model.DomainValidationRecord.ReadOnly = new Wrapper(impl)
}
