package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, Base64}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DownloadDefaultKeyPairResponse(
    publicKeyBase64: Option[Base64] = None,
    privateKeyBase64: Option[Base64] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse = {
    import DownloadDefaultKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
      .builder()
      .optionallyWith(
        publicKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.publicKeyBase64)
      .optionallyWith(
        privateKeyBase64.map(value => Base64.unwrap(value): java.lang.String)
      )(_.privateKeyBase64)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.wrap(buildAwsValue())
}
object DownloadDefaultKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DownloadDefaultKeyPairResponse =
      zio.aws.lightsail.model.DownloadDefaultKeyPairResponse(
        publicKeyBase64.map(value => value),
        privateKeyBase64.map(value => value),
        createdAt.map(value => value)
      )
    def publicKeyBase64: Option[Base64]
    def privateKeyBase64: Option[Base64]
    def createdAt: Option[IsoDate]
    def getPublicKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64)
    def getPrivateKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ) extends zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly {
    override val publicKeyBase64: Option[Base64] = scala
      .Option(impl.publicKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val privateKeyBase64: Option[Base64] = scala
      .Option(impl.privateKeyBase64())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ): zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
