package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EndpointRequest(
    containerName: String,
    containerPort: Integer,
    healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.EndpointRequest = {
    import EndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EndpointRequest
      .builder()
      .containerName(containerName: java.lang.String)
      .containerPort(containerPort: java.lang.Integer)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.EndpointRequest.ReadOnly =
    zio.aws.lightsail.model.EndpointRequest.wrap(buildAwsValue())
}
object EndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.EndpointRequest =
      zio.aws.lightsail.model.EndpointRequest(
        containerName,
        containerPort,
        healthCheck.map(value => value.asEditable)
      )
    def containerName: String
    def containerPort: Integer
    def healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ]
    def getContainerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerName)
    def getContainerPort: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(containerPort)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ) extends zio.aws.lightsail.model.EndpointRequest.ReadOnly {
    override val containerName: String = impl.containerName(): String
    override val containerPort: Integer = impl.containerPort(): Integer
    override val healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ): zio.aws.lightsail.model.EndpointRequest.ReadOnly = new Wrapper(impl)
}
