package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ExportSnapshotRecordSourceType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType
}
object ExportSnapshotRecordSourceType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType
  ): zio.aws.lightsail.model.ExportSnapshotRecordSourceType = value match {
    case software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.INSTANCE_SNAPSHOT =>
      val r = InstanceSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.DISK_SNAPSHOT =>
      val r = DiskSnapshot
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ExportSnapshotRecordSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType =
      software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceSnapshot
      extends zio.aws.lightsail.model.ExportSnapshotRecordSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType =
      software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.INSTANCE_SNAPSHOT
  }
  case object DiskSnapshot
      extends zio.aws.lightsail.model.ExportSnapshotRecordSourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType =
      software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceType.DISK_SNAPSHOT
  }
}
