package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportSnapshotRequest(sourceSnapshotName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest = {
    import ExportSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
      .builder()
      .sourceSnapshotName(
        ResourceName.unwrap(sourceSnapshotName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ExportSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.ExportSnapshotRequest.wrap(buildAwsValue())
}
object ExportSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ExportSnapshotRequest =
      zio.aws.lightsail.model.ExportSnapshotRequest(sourceSnapshotName)
    def sourceSnapshotName: ResourceName
    def getSourceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(sourceSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ) extends zio.aws.lightsail.model.ExportSnapshotRequest.ReadOnly {
    override val sourceSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.sourceSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ): zio.aws.lightsail.model.ExportSnapshotRequest.ReadOnly = new Wrapper(impl)
}
