package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ForwardValues {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ForwardValues
}
object ForwardValues {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ForwardValues
  ): zio.aws.lightsail.model.ForwardValues = value match {
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.ALLOW_LIST =>
      val r = `allow-list`
      r
    case software.amazon.awssdk.services.lightsail.model.ForwardValues.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ForwardValues {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ForwardValues =
      software.amazon.awssdk.services.lightsail.model.ForwardValues.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.lightsail.model.ForwardValues {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ForwardValues =
      software.amazon.awssdk.services.lightsail.model.ForwardValues.NONE
  }
  case object `allow-list` extends zio.aws.lightsail.model.ForwardValues {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ForwardValues =
      software.amazon.awssdk.services.lightsail.model.ForwardValues.ALLOW_LIST
  }
  case object all extends zio.aws.lightsail.model.ForwardValues {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ForwardValues =
      software.amazon.awssdk.services.lightsail.model.ForwardValues.ALL
  }
}
