package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetActiveNamesResponse(
    activeNames: Option[Iterable[String]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse = {
    import GetActiveNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
      .builder()
      .optionallyWith(
        activeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.activeNames)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly =
    zio.aws.lightsail.model.GetActiveNamesResponse.wrap(buildAwsValue())
}
object GetActiveNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetActiveNamesResponse =
      zio.aws.lightsail.model.GetActiveNamesResponse(
        activeNames.map(value => value),
        nextPageToken.map(value => value)
      )
    def activeNames: Option[List[String]]
    def nextPageToken: Option[String]
    def getActiveNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("activeNames", activeNames)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ) extends zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly {
    override val activeNames: Option[List[String]] = scala
      .Option(impl.activeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse
  ): zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly = new Wrapper(impl)
}
