package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAlarmsResponse(
    alarms: Option[Iterable[zio.aws.lightsail.model.Alarm]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse = {
    import GetAlarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
      .builder()
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly =
    zio.aws.lightsail.model.GetAlarmsResponse.wrap(buildAwsValue())
}
object GetAlarmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAlarmsResponse =
      zio.aws.lightsail.model.GetAlarmsResponse(
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def alarms: Option[List[zio.aws.lightsail.model.Alarm.ReadOnly]]
    def nextPageToken: Option[String]
    def getAlarms
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Alarm.ReadOnly]] =
      AwsError.unwrapOptionField("alarms", alarms)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ) extends zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly {
    override val alarms: Option[List[zio.aws.lightsail.model.Alarm.ReadOnly]] =
      scala
        .Option(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Alarm.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse
  ): zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly = new Wrapper(impl)
}
