package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAutoSnapshotsRequest(resourceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest = {
    import GetAutoSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAutoSnapshotsRequest.ReadOnly =
    zio.aws.lightsail.model.GetAutoSnapshotsRequest.wrap(buildAwsValue())
}
object GetAutoSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAutoSnapshotsRequest =
      zio.aws.lightsail.model.GetAutoSnapshotsRequest(resourceName)
    def resourceName: ResourceName
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest
  ) extends zio.aws.lightsail.model.GetAutoSnapshotsRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest
  ): zio.aws.lightsail.model.GetAutoSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
