package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAutoSnapshotsResponse(
    resourceName: Option[ResourceName] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    autoSnapshots: Option[
      Iterable[zio.aws.lightsail.model.AutoSnapshotDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse = {
    import GetAutoSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        autoSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoSnapshots)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly =
    zio.aws.lightsail.model.GetAutoSnapshotsResponse.wrap(buildAwsValue())
}
object GetAutoSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAutoSnapshotsResponse =
      zio.aws.lightsail.model.GetAutoSnapshotsResponse(
        resourceName.map(value => value),
        resourceType.map(value => value),
        autoSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: Option[ResourceName]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def autoSnapshots
        : Option[List[zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly]]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAutoSnapshots: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("autoSnapshots", autoSnapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ) extends zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly {
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val autoSnapshots
        : Option[List[zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly]] =
      scala
        .Option(impl.autoSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AutoSnapshotDetails.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ): zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
