package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.BucketName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBucketAccessKeysRequest(bucketName: BucketName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest = {
    import GetBucketAccessKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketAccessKeysRequest.ReadOnly =
    zio.aws.lightsail.model.GetBucketAccessKeysRequest.wrap(buildAwsValue())
}
object GetBucketAccessKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketAccessKeysRequest =
      zio.aws.lightsail.model.GetBucketAccessKeysRequest(bucketName)
    def bucketName: BucketName
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest
  ) extends zio.aws.lightsail.model.GetBucketAccessKeysRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest
  ): zio.aws.lightsail.model.GetBucketAccessKeysRequest.ReadOnly = new Wrapper(
    impl
  )
}
