package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketAccessKeysResponse(
    accessKeys: Option[Iterable[zio.aws.lightsail.model.AccessKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse = {
    import GetBucketAccessKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
      .builder()
      .optionallyWith(
        accessKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessKeys)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly =
    zio.aws.lightsail.model.GetBucketAccessKeysResponse.wrap(buildAwsValue())
}
object GetBucketAccessKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketAccessKeysResponse =
      zio.aws.lightsail.model.GetBucketAccessKeysResponse(
        accessKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accessKeys: Option[List[zio.aws.lightsail.model.AccessKey.ReadOnly]]
    def getAccessKeys
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AccessKey.ReadOnly]] =
      AwsError.unwrapOptionField("accessKeys", accessKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ) extends zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly {
    override val accessKeys
        : Option[List[zio.aws.lightsail.model.AccessKey.ReadOnly]] = scala
      .Option(impl.accessKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.AccessKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ): zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly = new Wrapper(
    impl
  )
}
