package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketBundlesResponse(
    bundles: Option[Iterable[zio.aws.lightsail.model.BucketBundle]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse = {
    import GetBucketBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly =
    zio.aws.lightsail.model.GetBucketBundlesResponse.wrap(buildAwsValue())
}
object GetBucketBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketBundlesResponse =
      zio.aws.lightsail.model.GetBucketBundlesResponse(
        bundles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bundles: Option[List[zio.aws.lightsail.model.BucketBundle.ReadOnly]]
    def getBundles: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.BucketBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ) extends zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly {
    override val bundles
        : Option[List[zio.aws.lightsail.model.BucketBundle.ReadOnly]] = scala
      .Option(impl.bundles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.BucketBundle.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ): zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly = new Wrapper(
    impl
  )
}
