package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import zio.aws.lightsail.model.primitives.{MetricPeriod, IsoDate, BucketName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetBucketMetricDataRequest(
    bucketName: BucketName,
    metricName: zio.aws.lightsail.model.BucketMetricName,
    startTime: IsoDate,
    endTime: IsoDate,
    period: MetricPeriod,
    statistics: Iterable[zio.aws.lightsail.model.MetricStatistic],
    unit: zio.aws.lightsail.model.MetricUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest = {
    import GetBucketMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(IsoDate.unwrap(startTime): Instant)
      .endTime(IsoDate.unwrap(endTime): Instant)
      .period(MetricPeriod.unwrap(period): Integer)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .unit(unit.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketMetricDataRequest.ReadOnly =
    zio.aws.lightsail.model.GetBucketMetricDataRequest.wrap(buildAwsValue())
}
object GetBucketMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketMetricDataRequest =
      zio.aws.lightsail.model.GetBucketMetricDataRequest(
        bucketName,
        metricName,
        startTime,
        endTime,
        period,
        statistics,
        unit
      )
    def bucketName: BucketName
    def metricName: zio.aws.lightsail.model.BucketMetricName
    def startTime: IsoDate
    def endTime: IsoDate
    def period: MetricPeriod
    def statistics: List[zio.aws.lightsail.model.MetricStatistic]
    def unit: zio.aws.lightsail.model.MetricUnit
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.lightsail.model.BucketMetricName] =
      ZIO.succeed(metricName)
    def getStartTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTime)
    def getPeriod: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(period)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.MetricStatistic]] =
      ZIO.succeed(statistics)
    def getUnit: ZIO[Any, Nothing, zio.aws.lightsail.model.MetricUnit] =
      ZIO.succeed(unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ) extends zio.aws.lightsail.model.GetBucketMetricDataRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val metricName: zio.aws.lightsail.model.BucketMetricName =
      zio.aws.lightsail.model.BucketMetricName.wrap(impl.metricName())
    override val startTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.startTime())
    override val endTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.endTime())
    override val period: MetricPeriod =
      zio.aws.lightsail.model.primitives.MetricPeriod(impl.period())
    override val statistics: List[zio.aws.lightsail.model.MetricStatistic] =
      impl
        .statistics()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.MetricStatistic.wrap(item)
        }
        .toList
    override val unit: zio.aws.lightsail.model.MetricUnit =
      zio.aws.lightsail.model.MetricUnit.wrap(impl.unit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ): zio.aws.lightsail.model.GetBucketMetricDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
