package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketMetricDataResponse(
    metricName: Option[zio.aws.lightsail.model.BucketMetricName] = None,
    metricData: Option[Iterable[zio.aws.lightsail.model.MetricDatapoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse = {
    import GetBucketMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetBucketMetricDataResponse.wrap(buildAwsValue())
}
object GetBucketMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketMetricDataResponse =
      zio.aws.lightsail.model.GetBucketMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Option[zio.aws.lightsail.model.BucketMetricName]
    def metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.lightsail.model.BucketMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse
  ) extends zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly {
    override val metricName: Option[zio.aws.lightsail.model.BucketMetricName] =
      scala
        .Option(impl.metricName())
        .map(value => zio.aws.lightsail.model.BucketMetricName.wrap(value))
    override val metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse
  ): zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
