package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketsResponse(
    buckets: Option[Iterable[zio.aws.lightsail.model.Bucket]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketsResponse = {
    import GetBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketsResponse.ReadOnly =
    zio.aws.lightsail.model.GetBucketsResponse.wrap(buildAwsValue())
}
object GetBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketsResponse =
      zio.aws.lightsail.model.GetBucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def buckets: Option[List[zio.aws.lightsail.model.Bucket.ReadOnly]]
    def nextPageToken: Option[String]
    def getBuckets
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Bucket.ReadOnly]] =
      AwsError.unwrapOptionField("buckets", buckets)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ) extends zio.aws.lightsail.model.GetBucketsResponse.ReadOnly {
    override val buckets
        : Option[List[zio.aws.lightsail.model.Bucket.ReadOnly]] = scala
      .Option(impl.buckets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Bucket.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ): zio.aws.lightsail.model.GetBucketsResponse.ReadOnly = new Wrapper(impl)
}
