package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBundlesRequest(
    includeInactive: Option[Boolean] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBundlesRequest = {
    import GetBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBundlesRequest.ReadOnly =
    zio.aws.lightsail.model.GetBundlesRequest.wrap(buildAwsValue())
}
object GetBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBundlesRequest =
      zio.aws.lightsail.model.GetBundlesRequest(
        includeInactive.map(value => value),
        pageToken.map(value => value)
      )
    def includeInactive: Option[Boolean]
    def pageToken: Option[String]
    def getIncludeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactive)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ) extends zio.aws.lightsail.model.GetBundlesRequest.ReadOnly {
    override val includeInactive: Option[Boolean] =
      scala.Option(impl.includeInactive()).map(value => value: Boolean)
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ): zio.aws.lightsail.model.GetBundlesRequest.ReadOnly = new Wrapper(impl)
}
