package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCertificatesResponse(
    certificates: Option[Iterable[zio.aws.lightsail.model.CertificateSummary]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse = {
    import GetCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly =
    zio.aws.lightsail.model.GetCertificatesResponse.wrap(buildAwsValue())
}
object GetCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCertificatesResponse =
      zio.aws.lightsail.model.GetCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificates
        : Option[List[zio.aws.lightsail.model.CertificateSummary.ReadOnly]]
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ) extends zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly {
    override val certificates
        : Option[List[zio.aws.lightsail.model.CertificateSummary.ReadOnly]] =
      scala
        .Option(impl.certificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CertificateSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ): zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
