package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContactMethodsRequest(
    protocols: Option[Iterable[zio.aws.lightsail.model.ContactProtocol]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest = {
    import GetContactMethodsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
      .builder()
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContactMethodsRequest.ReadOnly =
    zio.aws.lightsail.model.GetContactMethodsRequest.wrap(buildAwsValue())
}
object GetContactMethodsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContactMethodsRequest =
      zio.aws.lightsail.model
        .GetContactMethodsRequest(protocols.map(value => value))
    def protocols: Option[List[zio.aws.lightsail.model.ContactProtocol]]
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.ContactProtocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ) extends zio.aws.lightsail.model.GetContactMethodsRequest.ReadOnly {
    override val protocols
        : Option[List[zio.aws.lightsail.model.ContactProtocol]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContactProtocol.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ): zio.aws.lightsail.model.GetContactMethodsRequest.ReadOnly = new Wrapper(
    impl
  )
}
