package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContactMethodsResponse(
    contactMethods: Option[Iterable[zio.aws.lightsail.model.ContactMethod]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse = {
    import GetContactMethodsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
      .builder()
      .optionallyWith(
        contactMethods.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactMethods)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly =
    zio.aws.lightsail.model.GetContactMethodsResponse.wrap(buildAwsValue())
}
object GetContactMethodsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContactMethodsResponse =
      zio.aws.lightsail.model.GetContactMethodsResponse(
        contactMethods.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def contactMethods
        : Option[List[zio.aws.lightsail.model.ContactMethod.ReadOnly]]
    def getContactMethods: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContactMethod.ReadOnly
    ]] = AwsError.unwrapOptionField("contactMethods", contactMethods)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ) extends zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly {
    override val contactMethods
        : Option[List[zio.aws.lightsail.model.ContactMethod.ReadOnly]] = scala
      .Option(impl.contactMethods())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContactMethod.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ): zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly = new Wrapper(
    impl
  )
}
