package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerApiMetadataResponse(
    metadata: Option[Iterable[Map[String, String]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse = {
    import GetContainerApiMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
      .builder()
      .optionallyWith(
        metadata.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerApiMetadataResponse
      .wrap(buildAwsValue())
}
object GetContainerApiMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerApiMetadataResponse =
      zio.aws.lightsail.model
        .GetContainerApiMetadataResponse(metadata.map(value => value))
    def metadata: Option[List[Map[String, String]]]
    def getMetadata: ZIO[Any, AwsError, List[Map[String, String]]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ) extends zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly {
    override val metadata: Option[List[Map[String, String]]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ): zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
