package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  MetricPeriod,
  IsoDate,
  ContainerServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetContainerServiceMetricDataRequest(
    serviceName: ContainerServiceName,
    metricName: zio.aws.lightsail.model.ContainerServiceMetricName,
    startTime: IsoDate,
    endTime: IsoDate,
    period: MetricPeriod,
    statistics: Iterable[zio.aws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest = {
    import GetContainerServiceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(IsoDate.unwrap(startTime): Instant)
      .endTime(IsoDate.unwrap(endTime): Instant)
      .period(MetricPeriod.unwrap(period): Integer)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly =
    zio.aws.lightsail.model.GetContainerServiceMetricDataRequest
      .wrap(buildAwsValue())
}
object GetContainerServiceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetContainerServiceMetricDataRequest =
      zio.aws.lightsail.model.GetContainerServiceMetricDataRequest(
        serviceName,
        metricName,
        startTime,
        endTime,
        period,
        statistics
      )
    def serviceName: ContainerServiceName
    def metricName: zio.aws.lightsail.model.ContainerServiceMetricName
    def startTime: IsoDate
    def endTime: IsoDate
    def period: MetricPeriod
    def statistics: List[zio.aws.lightsail.model.MetricStatistic]
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getMetricName: ZIO[
      Any,
      Nothing,
      zio.aws.lightsail.model.ContainerServiceMetricName
    ] = ZIO.succeed(metricName)
    def getStartTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTime)
    def getPeriod: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(period)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.MetricStatistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ) extends zio.aws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val metricName
        : zio.aws.lightsail.model.ContainerServiceMetricName =
      zio.aws.lightsail.model.ContainerServiceMetricName.wrap(impl.metricName())
    override val startTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.startTime())
    override val endTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.endTime())
    override val period: MetricPeriod =
      zio.aws.lightsail.model.primitives.MetricPeriod(impl.period())
    override val statistics: List[zio.aws.lightsail.model.MetricStatistic] =
      impl
        .statistics()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.MetricStatistic.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ): zio.aws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
