package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskSnapshotResponse(
    diskSnapshot: Option[zio.aws.lightsail.model.DiskSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse = {
    import GetDiskSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
      .builder()
      .optionallyWith(diskSnapshot.map(value => value.buildAwsValue()))(
        _.diskSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly =
    zio.aws.lightsail.model.GetDiskSnapshotResponse.wrap(buildAwsValue())
}
object GetDiskSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskSnapshotResponse =
      zio.aws.lightsail.model
        .GetDiskSnapshotResponse(diskSnapshot.map(value => value.asEditable))
    def diskSnapshot: Option[zio.aws.lightsail.model.DiskSnapshot.ReadOnly]
    def getDiskSnapshot
        : ZIO[Any, AwsError, zio.aws.lightsail.model.DiskSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("diskSnapshot", diskSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ) extends zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly {
    override val diskSnapshot
        : Option[zio.aws.lightsail.model.DiskSnapshot.ReadOnly] = scala
      .Option(impl.diskSnapshot())
      .map(value => zio.aws.lightsail.model.DiskSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ): zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
