package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskSnapshotsRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest = {
    import GetDiskSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly =
    zio.aws.lightsail.model.GetDiskSnapshotsRequest.wrap(buildAwsValue())
}
object GetDiskSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskSnapshotsRequest =
      zio.aws.lightsail.model
        .GetDiskSnapshotsRequest(pageToken.map(value => value))
    def pageToken: Option[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ) extends zio.aws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly {
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ): zio.aws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
