package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDisksRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDisksRequest = {
    import GetDisksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDisksRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDisksRequest.ReadOnly =
    zio.aws.lightsail.model.GetDisksRequest.wrap(buildAwsValue())
}
object GetDisksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDisksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDisksRequest =
      zio.aws.lightsail.model.GetDisksRequest(pageToken.map(value => value))
    def pageToken: Option[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksRequest
  ) extends zio.aws.lightsail.model.GetDisksRequest.ReadOnly {
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksRequest
  ): zio.aws.lightsail.model.GetDisksRequest.ReadOnly = new Wrapper(impl)
}
