package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDisksResponse(
    disks: Option[Iterable[zio.aws.lightsail.model.Disk]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDisksResponse = {
    import GetDisksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDisksResponse
      .builder()
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDisksResponse.ReadOnly =
    zio.aws.lightsail.model.GetDisksResponse.wrap(buildAwsValue())
}
object GetDisksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDisksResponse =
      zio.aws.lightsail.model.GetDisksResponse(
        disks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def disks: Option[List[zio.aws.lightsail.model.Disk.ReadOnly]]
    def nextPageToken: Option[String]
    def getDisks
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      AwsError.unwrapOptionField("disks", disks)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ) extends zio.aws.lightsail.model.GetDisksResponse.ReadOnly {
    override val disks: Option[List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      scala
        .Option(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ): zio.aws.lightsail.model.GetDisksResponse.ReadOnly = new Wrapper(impl)
}
