package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetDistributionLatestCacheResetResponse(
    status: Option[String] = None,
    createTime: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse = {
    import GetDistributionLatestCacheResetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(createTime.map(value => IsoDate.unwrap(value): Instant))(
        _.createTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly =
    zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse
      .wrap(buildAwsValue())
}
object GetDistributionLatestCacheResetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse =
      zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse(
        status.map(value => value),
        createTime.map(value => value)
      )
    def status: Option[String]
    def createTime: Option[IsoDate]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCreateTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createTime", createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ) extends zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly {
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val createTime: Option[IsoDate] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ): zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly =
    new Wrapper(impl)
}
