package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionsRequest(
    distributionName: Option[ResourceName] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest = {
    import GetDistributionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
      .builder()
      .optionallyWith(
        distributionName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.distributionName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly =
    zio.aws.lightsail.model.GetDistributionsRequest.wrap(buildAwsValue())
}
object GetDistributionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionsRequest =
      zio.aws.lightsail.model.GetDistributionsRequest(
        distributionName.map(value => value),
        pageToken.map(value => value)
      )
    def distributionName: Option[ResourceName]
    def pageToken: Option[String]
    def getDistributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ) extends zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly {
    override val distributionName: Option[ResourceName] = scala
      .Option(impl.distributionName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ): zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
