package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDomainsResponse(
    domains: Option[Iterable[zio.aws.lightsail.model.Domain]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainsResponse = {
    import GetDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
      .builder()
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDomainsResponse.ReadOnly =
    zio.aws.lightsail.model.GetDomainsResponse.wrap(buildAwsValue())
}
object GetDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDomainsResponse =
      zio.aws.lightsail.model.GetDomainsResponse(
        domains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def domains: Option[List[zio.aws.lightsail.model.Domain.ReadOnly]]
    def nextPageToken: Option[String]
    def getDomains
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Domain.ReadOnly]] =
      AwsError.unwrapOptionField("domains", domains)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ) extends zio.aws.lightsail.model.GetDomainsResponse.ReadOnly {
    override val domains
        : Option[List[zio.aws.lightsail.model.Domain.ReadOnly]] = scala
      .Option(impl.domains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Domain.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ): zio.aws.lightsail.model.GetDomainsResponse.ReadOnly = new Wrapper(impl)
}
