package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceAccessDetailsResponse(
    accessDetails: Option[zio.aws.lightsail.model.InstanceAccessDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse = {
    import GetInstanceAccessDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
      .builder()
      .optionallyWith(accessDetails.map(value => value.buildAwsValue()))(
        _.accessDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceAccessDetailsResponse
      .wrap(buildAwsValue())
}
object GetInstanceAccessDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceAccessDetailsResponse =
      zio.aws.lightsail.model.GetInstanceAccessDetailsResponse(
        accessDetails.map(value => value.asEditable)
      )
    def accessDetails
        : Option[zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly]
    def getAccessDetails: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly
    ] = AwsError.unwrapOptionField("accessDetails", accessDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ) extends zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly {
    override val accessDetails
        : Option[zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly] = scala
      .Option(impl.accessDetails())
      .map(value => zio.aws.lightsail.model.InstanceAccessDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ): zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
