package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  Timestamp,
  MetricPeriod,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetInstanceMetricDataRequest(
    instanceName: ResourceName,
    metricName: zio.aws.lightsail.model.InstanceMetricName,
    period: MetricPeriod,
    startTime: Timestamp,
    endTime: Timestamp,
    unit: zio.aws.lightsail.model.MetricUnit,
    statistics: Iterable[zio.aws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest = {
    import GetInstanceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .metricName(metricName.unwrap)
      .period(MetricPeriod.unwrap(period): Integer)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstanceMetricDataRequest.wrap(buildAwsValue())
}
object GetInstanceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceMetricDataRequest =
      zio.aws.lightsail.model.GetInstanceMetricDataRequest(
        instanceName,
        metricName,
        period,
        startTime,
        endTime,
        unit,
        statistics
      )
    def instanceName: ResourceName
    def metricName: zio.aws.lightsail.model.InstanceMetricName
    def period: MetricPeriod
    def startTime: Timestamp
    def endTime: Timestamp
    def unit: zio.aws.lightsail.model.MetricUnit
    def statistics: List[zio.aws.lightsail.model.MetricStatistic]
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getMetricName
        : ZIO[Any, Nothing, zio.aws.lightsail.model.InstanceMetricName] =
      ZIO.succeed(metricName)
    def getPeriod: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(period)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getUnit: ZIO[Any, Nothing, zio.aws.lightsail.model.MetricUnit] =
      ZIO.succeed(unit)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.MetricStatistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ) extends zio.aws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val metricName: zio.aws.lightsail.model.InstanceMetricName =
      zio.aws.lightsail.model.InstanceMetricName.wrap(impl.metricName())
    override val period: MetricPeriod =
      zio.aws.lightsail.model.primitives.MetricPeriod(impl.period())
    override val startTime: Timestamp =
      zio.aws.lightsail.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.lightsail.model.primitives.Timestamp(impl.endTime())
    override val unit: zio.aws.lightsail.model.MetricUnit =
      zio.aws.lightsail.model.MetricUnit.wrap(impl.unit())
    override val statistics: List[zio.aws.lightsail.model.MetricStatistic] =
      impl
        .statistics()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.MetricStatistic.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ): zio.aws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
