package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceMetricDataResponse(
    metricName: Option[zio.aws.lightsail.model.InstanceMetricName] = None,
    metricData: Option[Iterable[zio.aws.lightsail.model.MetricDatapoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse = {
    import GetInstanceMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceMetricDataResponse.wrap(buildAwsValue())
}
object GetInstanceMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceMetricDataResponse =
      zio.aws.lightsail.model.GetInstanceMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Option[zio.aws.lightsail.model.InstanceMetricName]
    def metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ) extends zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly {
    override val metricName
        : Option[zio.aws.lightsail.model.InstanceMetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.lightsail.model.InstanceMetricName.wrap(value))
    override val metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ): zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
