package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstancePortStatesRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest = {
    import GetInstancePortStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstancePortStatesRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstancePortStatesRequest.wrap(buildAwsValue())
}
object GetInstancePortStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstancePortStatesRequest =
      zio.aws.lightsail.model.GetInstancePortStatesRequest(instanceName)
    def instanceName: ResourceName
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ) extends zio.aws.lightsail.model.GetInstancePortStatesRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest
  ): zio.aws.lightsail.model.GetInstancePortStatesRequest.ReadOnly =
    new Wrapper(impl)
}
