package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotResponse(
    instanceSnapshot: Option[zio.aws.lightsail.model.InstanceSnapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse = {
    import GetInstanceSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
      .builder()
      .optionallyWith(instanceSnapshot.map(value => value.buildAwsValue()))(
        _.instanceSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceSnapshotResponse.wrap(buildAwsValue())
}
object GetInstanceSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceSnapshotResponse =
      zio.aws.lightsail.model.GetInstanceSnapshotResponse(
        instanceSnapshot.map(value => value.asEditable)
      )
    def instanceSnapshot
        : Option[zio.aws.lightsail.model.InstanceSnapshot.ReadOnly]
    def getInstanceSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceSnapshot.ReadOnly
    ] = AwsError.unwrapOptionField("instanceSnapshot", instanceSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ) extends zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly {
    override val instanceSnapshot
        : Option[zio.aws.lightsail.model.InstanceSnapshot.ReadOnly] = scala
      .Option(impl.instanceSnapshot())
      .map(value => zio.aws.lightsail.model.InstanceSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ): zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
