package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotsResponse(
    instanceSnapshots: Option[
      Iterable[zio.aws.lightsail.model.InstanceSnapshot]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse = {
    import GetInstanceSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
      .builder()
      .optionallyWith(
        instanceSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceSnapshotsResponse.wrap(buildAwsValue())
}
object GetInstanceSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceSnapshotsResponse =
      zio.aws.lightsail.model.GetInstanceSnapshotsResponse(
        instanceSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def instanceSnapshots
        : Option[List[zio.aws.lightsail.model.InstanceSnapshot.ReadOnly]]
    def nextPageToken: Option[String]
    def getInstanceSnapshots: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.InstanceSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceSnapshots", instanceSnapshots)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ) extends zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly {
    override val instanceSnapshots
        : Option[List[zio.aws.lightsail.model.InstanceSnapshot.ReadOnly]] =
      scala
        .Option(impl.instanceSnapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.InstanceSnapshot.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ): zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
