package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceStateRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest = {
    import GetInstanceStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstanceStateRequest.ReadOnly =
    zio.aws.lightsail.model.GetInstanceStateRequest.wrap(buildAwsValue())
}
object GetInstanceStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceStateRequest =
      zio.aws.lightsail.model.GetInstanceStateRequest(instanceName)
    def instanceName: ResourceName
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ) extends zio.aws.lightsail.model.GetInstanceStateRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ): zio.aws.lightsail.model.GetInstanceStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
