package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstancesResponse(
    instances: Option[Iterable[zio.aws.lightsail.model.Instance]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancesResponse = {
    import GetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetInstancesResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstancesResponse.wrap(buildAwsValue())
}
object GetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstancesResponse =
      zio.aws.lightsail.model.GetInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def instances: Option[List[zio.aws.lightsail.model.Instance.ReadOnly]]
    def nextPageToken: Option[String]
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ) extends zio.aws.lightsail.model.GetInstancesResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.lightsail.model.Instance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Instance.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ): zio.aws.lightsail.model.GetInstancesResponse.ReadOnly = new Wrapper(impl)
}
