package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetKeyPairResponse(
    keyPair: Option[zio.aws.lightsail.model.KeyPair] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse = {
    import GetKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly =
    zio.aws.lightsail.model.GetKeyPairResponse.wrap(buildAwsValue())
}
object GetKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetKeyPairResponse =
      zio.aws.lightsail.model
        .GetKeyPairResponse(keyPair.map(value => value.asEditable))
    def keyPair: Option[zio.aws.lightsail.model.KeyPair.ReadOnly]
    def getKeyPair
        : ZIO[Any, AwsError, zio.aws.lightsail.model.KeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ) extends zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly {
    override val keyPair: Option[zio.aws.lightsail.model.KeyPair.ReadOnly] =
      scala
        .Option(impl.keyPair())
        .map(value => zio.aws.lightsail.model.KeyPair.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ): zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly = new Wrapper(impl)
}
