package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerMetricDataResponse(
    metricName: Option[zio.aws.lightsail.model.LoadBalancerMetricName] = None,
    metricData: Option[Iterable[zio.aws.lightsail.model.MetricDatapoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse = {
    import GetLoadBalancerMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse =
      zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Option[zio.aws.lightsail.model.LoadBalancerMetricName]
    def metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancerMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ) extends zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly {
    override val metricName
        : Option[zio.aws.lightsail.model.LoadBalancerMetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.lightsail.model.LoadBalancerMetricName.wrap(value))
    override val metricData
        : Option[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ): zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
