package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerRequest(loadBalancerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest = {
    import GetLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetLoadBalancerRequest.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerRequest.wrap(buildAwsValue())
}
object GetLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancerRequest =
      zio.aws.lightsail.model.GetLoadBalancerRequest(loadBalancerName)
    def loadBalancerName: ResourceName
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ) extends zio.aws.lightsail.model.GetLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ): zio.aws.lightsail.model.GetLoadBalancerRequest.ReadOnly = new Wrapper(impl)
}
