package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerTlsCertificatesResponse(
    tlsCertificates: Option[
      Iterable[zio.aws.lightsail.model.LoadBalancerTlsCertificate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse = {
    import GetLoadBalancerTlsCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
      .builder()
      .optionallyWith(
        tlsCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsCertificates)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse =
      zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse(
        tlsCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tlsCertificates: Option[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly]
    ]
    def getTlsCertificates: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly
    ]] = AwsError.unwrapOptionField("tlsCertificates", tlsCertificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ) extends zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly {
    override val tlsCertificates: Option[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly]
    ] = scala
      .Option(impl.tlsCertificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse
  ): zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
