package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetOperationRequest(operationId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationRequest = {
    import GetOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationRequest
      .builder()
      .operationId(NonEmptyString.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetOperationRequest.ReadOnly =
    zio.aws.lightsail.model.GetOperationRequest.wrap(buildAwsValue())
}
object GetOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetOperationRequest =
      zio.aws.lightsail.model.GetOperationRequest(operationId)
    def operationId: NonEmptyString
    def getOperationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ) extends zio.aws.lightsail.model.GetOperationRequest.ReadOnly {
    override val operationId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ): zio.aws.lightsail.model.GetOperationRequest.ReadOnly = new Wrapper(impl)
}
