package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOperationsForResourceRequest(
    resourceName: ResourceName,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest = {
    import GetOperationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetOperationsForResourceRequest.ReadOnly =
    zio.aws.lightsail.model.GetOperationsForResourceRequest
      .wrap(buildAwsValue())
}
object GetOperationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetOperationsForResourceRequest =
      zio.aws.lightsail.model.GetOperationsForResourceRequest(
        resourceName,
        pageToken.map(value => value)
      )
    def resourceName: ResourceName
    def pageToken: Option[String]
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ) extends zio.aws.lightsail.model.GetOperationsForResourceRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ): zio.aws.lightsail.model.GetOperationsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
