package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOperationsForResourceResponse(
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None,
    nextPageCount: Option[String] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse = {
    import GetOperationsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(nextPageCount.map(value => value: java.lang.String))(
        _.nextPageCount
      )
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly =
    zio.aws.lightsail.model.GetOperationsForResourceResponse
      .wrap(buildAwsValue())
}
object GetOperationsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetOperationsForResourceResponse =
      zio.aws.lightsail.model.GetOperationsForResourceResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageCount.map(value => value),
        nextPageToken.map(value => value)
      )
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def nextPageCount: Option[String]
    def nextPageToken: Option[String]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
    def getNextPageCount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageCount", nextPageCount)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ) extends zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly {
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
    override val nextPageCount: Option[String] =
      scala.Option(impl.nextPageCount()).map(value => value: String)
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ): zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
