package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRegionsRequest(
    includeAvailabilityZones: Option[Boolean] = None,
    includeRelationalDatabaseAvailabilityZones: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRegionsRequest = {
    import GetRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
      .builder()
      .optionallyWith(
        includeAvailabilityZones.map(value => value: java.lang.Boolean)
      )(_.includeAvailabilityZones)
      .optionallyWith(
        includeRelationalDatabaseAvailabilityZones.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeRelationalDatabaseAvailabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetRegionsRequest.ReadOnly =
    zio.aws.lightsail.model.GetRegionsRequest.wrap(buildAwsValue())
}
object GetRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetRegionsRequest =
      zio.aws.lightsail.model.GetRegionsRequest(
        includeAvailabilityZones.map(value => value),
        includeRelationalDatabaseAvailabilityZones.map(value => value)
      )
    def includeAvailabilityZones: Option[Boolean]
    def includeRelationalDatabaseAvailabilityZones: Option[Boolean]
    def getIncludeAvailabilityZones: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeAvailabilityZones", includeAvailabilityZones)
    def getIncludeRelationalDatabaseAvailabilityZones
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "includeRelationalDatabaseAvailabilityZones",
      includeRelationalDatabaseAvailabilityZones
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ) extends zio.aws.lightsail.model.GetRegionsRequest.ReadOnly {
    override val includeAvailabilityZones: Option[Boolean] =
      scala.Option(impl.includeAvailabilityZones()).map(value => value: Boolean)
    override val includeRelationalDatabaseAvailabilityZones: Option[Boolean] =
      scala
        .Option(impl.includeRelationalDatabaseAvailabilityZones())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ): zio.aws.lightsail.model.GetRegionsRequest.ReadOnly = new Wrapper(impl)
}
